#include "jabber_sdk_wrap_impl.h"
#include "jabber_sdk_wrap.h"
#include "autoupgrade/MeetingSDKMgr.h"
#include "services/impl/NetUtilBridge.h"

#include "csf/logger/CSFLogger.hpp"
#include "csf/Mutex.hpp"
#include "csf/ScopedLock.hpp"

#include <assert.h>

static CSFLogger* JabberSDKWrapImplLogger = CSFLogger_getLogger("MeetingService-JabberSDKWrapImplLogger");

static csf::Mutex mutex;

namespace JM_SDK_WRAP
{
	
	JabberSDKWrapImpl * JabberSDKWrapImpl::m_pInstance = NULL;

    JabberSDKWrapImpl::JabberSDKWrapImpl()
    {
		m_bIsSDKLoadSuccessful = loadSDKModule();
    }

	JabberSDKWrapImpl* JabberSDKWrapImpl::getInstance()
	{
		csf::ScopedLock lock(mutex);
		if (NULL == m_pInstance)
		{
			m_pInstance = new JabberSDKWrapImpl();
		}
		return m_pInstance;
	}

    bool JabberSDKWrapImpl::loadSDKModule()
    {
		if (!MeetingSDKMgr::getInstance()->loadSDKModule())
		{
			CSFLogErrorS(JabberSDKWrapImplLogger, "Load Meeting SDK module failed.");
			return false;
		}
		mLibHandle = MeetingSDKMgr::getInstance()->getSDKModule();
        
        m_IJMIMCallbackImpl.FuncInit(mLibHandle);
        m_IJMCommonEventCallbackImpl.FuncInit(mLibHandle);
		m_JMMeetingMgrImpl.FuncInit(mLibHandle);
		m_IWbxMeetingAccountMgrImpl.FuncInit(mLibHandle);
		m_IMeetingAccountInfoCallbackImpl.FuncInit(mLibHandle);
		m_IInstantMeetingMgrImpl.FuncInit(mLibHandle);
		m_IDSMgrImpl.FuncInit(mLibHandle);
        
		m_IJMIMDelegeteWrapper.FuncInit(mLibHandle);
		m_ICommonDependenciesDelegateWrapper.FuncInit(mLibHandle);
		m_JMLoggerWrapper.FuncInit(mLibHandle);
		m_JMProxyWrapper.FuncInit(mLibHandle);
		m_INetworkTransportWrapper.FuncInit(mLibHandle);
		m_JMMeetingMgrHandlerWrapper.FuncInit(mLibHandle);
		m_IWbxMeetingAccountObserveWrapper.FuncInit(mLibHandle);
		m_IMeetingAccountInfoDelegateWrapper.FuncInit(mLibHandle);
		m_IInstantMeetingEventWrapper.FuncInit(mLibHandle);
		m_IDSMgrEventWrapper.FuncInit(mLibHandle);

        return true;
    }


    void JabberSDKWrapImpl::freeSDKModule()
    {
		m_IJMIMCallbackImpl.FuncUnInit();
		m_IJMCommonEventCallbackImpl.FuncUnInit();
		m_JMMeetingMgrImpl.FuncUnInit();
		m_IWbxMeetingAccountMgrImpl.FuncUnInit();
		m_IMeetingAccountInfoCallbackImpl.FuncUnInit();
		m_IInstantMeetingMgrImpl.FuncUnInit();
		m_IDSMgrImpl.FuncUnInit();

		m_IJMIMDelegeteWrapper.SetHandler(NULL);
		m_ICommonDependenciesDelegateWrapper.SetHandler(NULL);
		m_JMLoggerWrapper.SetHandler(NULL);
		m_JMProxyWrapper.SetHandler(NULL);
		m_INetworkTransportWrapper.SetHandler(NULL);
		m_JMMeetingMgrHandlerWrapper.SetHandler(NULL);
		m_IWbxMeetingAccountObserveWrapper.SetHandler(NULL);
		m_IMeetingAccountInfoDelegateWrapper.SetHandler(NULL);
		m_IInstantMeetingEventWrapper.SetHandler(NULL);
		m_IDSMgrEventWrapper.SetHandler(NULL);

		MeetingSDKMgr::getInstance()->unloadSDKModule();
    }

	std::string JabberSDKWrapImpl::getSDKFolder()
	{
		return MeetingSDKMgr::getInstance()->getTargetSDKFolder();
	}

	void JabberSDKWrapImpl::setTraceLocation(const WCHAR* location)
	{
		typedef void(*PFSetTraceLocation)(const WCHAR* location);
		PFSetTraceLocation pFunc = (PFSetTraceLocation)GetProcAddress(mLibHandle, "jm_set_trace_location");
		assert(pFunc != NULL);
		pFunc(location);
	}

	void JabberSDKWrapImpl::startMeetingSDK()
	{
		if (m_MeetingNetUtilTransport == NULL && m_unifiedFactory != NULL)
		{
			m_MeetingNetUtilTransport.reset(new NetUtilTransport(m_unifiedFactory));
			setNetworkTransport(m_MeetingNetUtilTransport.get());
		}
	}

	void JabberSDKWrapImpl::stopMeetingSDK()
	{
		if (m_MeetingNetUtilTransport != NULL)
		{
			m_MeetingNetUtilTransport->CancelAllRequest();
		}
	}
    
    void JabberSDKWrapImpl::networkChanged(bool bConnected)
    {
        if (bConnected) {
            return;
        }
        
        if (m_MeetingNetUtilTransport != NULL)
        {
            m_MeetingNetUtilTransport->CancelAllRequest();
        }
    }
}

